<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreMetroSlider extends VisualizzatoreComponente {
        private $javascriptAssociato;
        private $impostazioniAspetto;
        private $articoliGiaPubblicati;
        private $articoliPerSlide;
        
        function __construct($db) {
            parent::__construct($db);
            $this->impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
            $this->articoliGiaPubblicati = array();
        }
        
        function generaContenutoSezione($dati) {
            $slider = parent::getDb()->leggiSingolaRiga("geec_metroSlider",$dati["idElemento"]);
            
            // questa variabile servirà per capire come organizzare le slide
            $this->articoliPerSlide = $slider["articoliPerSlide"];
            
            $classeAggiuntivaMetroSlider = ($this->articoliPerSlide==5) ? "template-2" : "";

            $idSlider = str_replace(array(" ",".","-"), "", $slider["nome"]).$dati["idElemento"];
            echo"<div class=\"{$slider["spazioOccupato"]}\">
                    <div id=\"$idSlider\" class=\"owl-carousel owl-theme articoli-dal-blog metro-slider $classeAggiuntivaMetroSlider\">";
                    $this->stampaSlide($dati);
                echo"</div>
               </div>";
            
            $this->javascriptAssociato = $this->generaJavascriptSlider($slider,$idSlider);
        }
        
        //metodo che crea le slide
        function stampaSlide($dati) {
            $querySlide="SELECT * FROM geec_slideMetro WHERE idSlider={$dati["idElemento"]} ORDER BY posizione ASC";
            $risSlide = parent::getDb()->eseguiQueryLettura($querySlide);

            if($risSlide->num_rows==0) {
                parent::messaggioDiErrore("Attenzione, non sono presenti slide. Crearle dal pannello amministrativo");
            }
            
            $numeroArticoli = parent::getDb()->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo"));
            $articoliNecessari = $risSlide->num_rows * $this->articoliPerSlide;
            if($numeroArticoli < $articoliNecessari) {
                parent::messaggioDiErrore("Attenzione: non è presente il numero minimo di articoli");
            }
            
            while($slide=$risSlide->fetch_assoc()) {
                switch ($slide["tipo"]) {
                    case 'ultimiArticoli':
                        $this->stampaSlideUltimiArticoli($slide);
                        break;
                    case 'categorie':
                        $this->stampaSlideArticoliCategorie($slide);
                        break;
                    case 'contenuti':
                        $this->stampaSlideArticoliSpecifici($slide);
                        break;
                }
            }
        }
    
        function stampaSlideUltimiArticoli($slide) {
            $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
            $queryArticoli = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' $stringaArticoliDaEvitare ORDER BY id DESC LIMIT $this->articoliPerSlide";
            $risQuery      = $this->getDb()->eseguiQueryLettura($queryArticoli);
            
            if($risQuery->num_rows<$this->articoliPerSlide) {
                echo"Attenzione: non è presente il numero minimo di articoli";
            }
            else {
                $arrayArticoliSlide = array();
                while($articolo = $risQuery->fetch_assoc()) {
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo["id"];
                    array_push($arrayArticoliSlide,$articolo);
                }
                
                if($this->articoliPerSlide==3) {
                    $this->stampaSlide3Elementi($arrayArticoliSlide);                    
                }
                else if($this->articoliPerSlide==5) {                
                    $this->stampaSlide5Elementi($arrayArticoliSlide);
                }
            }
        }
        
        function stampaSlideArticoliCategorie($slide) {
            $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
            
            if($slide["contenuti"]=="") {
                parent::messaggioDiErrore("Attenzione, questa slide non è configurata. Configurarla dal pannello amministrativo");
            }
            else {
                $arrayCategorie = explode(",", $slide["contenuti"]);

                /*
                 * se vengono inserite meno di 5 categorie le categorie mancanti verranno
                 * riempite con i valori presenti (esempio se l'utente inserisce una sola
                 * categoria le altre due posizioni dell'array verranno riempite con quella
                 * categoria)
                 */
                if(count($arrayCategorie)==1) {
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                }
                else if(count($arrayCategorie)==2){
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[1];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                }
                else if(count($arrayCategorie)==3){
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[0];
                    $arrayCategorie[count($arrayCategorie)] = $arrayCategorie[1];
                }

                $arrayArticoliSlide = array();
                $queryPrimoArticolo = "SELECT * FROM geecB_contenuti WHERE categoria={$arrayCategorie[0]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$arrayCategorie[0]}) $stringaArticoliDaEvitare ORDER BY id DESC LIMIT 1";
                $risQuery   = $this->getDb()->eseguiQueryLettura($queryPrimoArticolo);
                $articolo1  = $risQuery->fetch_assoc();
                if($articolo1!=null) {
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo1["id"];
                    array_push($arrayArticoliSlide, $articolo1);
                }

                $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
                $querySecondoArticolo = "SELECT * FROM geecB_contenuti WHERE (categoria={$arrayCategorie[1]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$arrayCategorie[1]})) $stringaArticoliDaEvitare ORDER BY id DESC LIMIT 1";
                $risQuery2          = $this->getDb()->eseguiQueryLettura($querySecondoArticolo);
                $articolo2         = $risQuery2->fetch_assoc();
                if($articolo2!=null) {            
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo2["id"];
                    array_push($arrayArticoliSlide, $articolo2);
                }

                $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
                $queryTerzoArticolo = "SELECT * FROM geecB_contenuti WHERE (categoria={$arrayCategorie[2]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$arrayCategorie[2]})) $stringaArticoliDaEvitare ORDER BY id DESC LIMIT 1";
                $risQuery3          = $this->getDb()->eseguiQueryLettura($queryTerzoArticolo);
                $articolo3          = $risQuery3->fetch_assoc();
                if($articolo3!=null) {            
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo3["id"];
                    array_push($arrayArticoliSlide, $articolo3);
                }

                // se sono 3 elementi effettua la stampa della slide con 3 elementi, se sono 5 aggiunge le slide mancanti e ricerca degli altri due
                if($this->articoliPerSlide==3) {
                    $this->stampaSlide3Elementi($arrayArticoliSlide);
                }
                else if($this->articoliPerSlide==5) {
                    $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
                    $queryQuartoArticolo = "SELECT * FROM geecB_contenuti WHERE (categoria={$arrayCategorie[3]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$arrayCategorie[3]})) $stringaArticoliDaEvitare ORDER BY id DESC LIMIT 1";
                    $risQuery4           = $this->getDb()->eseguiQueryLettura($queryQuartoArticolo);
                    $articolo4           = $risQuery4->fetch_assoc();
                    if($articolo4!=null) { 
                        $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo4["id"];
                        array_push($arrayArticoliSlide, $articolo4);
                    }

                    $stringaArticoliDaEvitare = $this->getStringaArticoliDaEvitare();
                    $queryQuintoArticolo = "SELECT * FROM geecB_contenuti WHERE (categoria={$arrayCategorie[4]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$arrayCategorie[4]})) $stringaArticoliDaEvitare ORDER BY id DESC LIMIT 1";
                    $risQuery5           = $this->getDb()->eseguiQueryLettura($queryQuintoArticolo);
                    $articolo5           = $risQuery5->fetch_assoc();
                    if($articolo5!=null) {
                        $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo5["id"];
                        array_push($arrayArticoliSlide, $articolo5);
                    }

                    $this->stampaSlide5Elementi($arrayArticoliSlide);
                }
            }
        }
        
        function stampaSlideArticoliSpecifici($slide) {
            if($slide["contenuti"]=="") {
                parent::messaggioDiErrore("Attenzione, questa slide non è configurata. Configurarla dal pannello amministrativo");
            }
            else {
                
                $arrayArticoli = explode(",", $slide["contenuti"]);
                $arrayArticoliSlide = array();

                $articolo1         = $this->getDb()->leggiSingolaRiga("geecB_contenuti",$arrayArticoli[0]);
                if($articolo1!=null) {
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo1["id"];
                    array_push($arrayArticoliSlide,$articolo1);
                }

                $articolo2         = $this->getDb()->leggiSingolaRiga("geecB_contenuti",$arrayArticoli[1]);
                if($articolo2!=null) {
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo2["id"];
                    array_push($arrayArticoliSlide,$articolo2);
                }

                $articolo3         = $this->getDb()->leggiSingolaRiga("geecB_contenuti",$arrayArticoli[2]);
                if($articolo3!=null) {
                    $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo3["id"];
                    array_push($arrayArticoliSlide,$articolo3);
                }

                // se sono 3 elementi effettua la stampa della slide con 3 elementi, se sono 5 aggiunge le slide mancanti e ricerca degli altri due
                if($this->articoliPerSlide==3) {
                    $this->stampaSlide3Elementi($arrayArticoliSlide);
                }
                else if($this->articoliPerSlide==5) {
                    $articolo4         = $this->getDb()->leggiSingolaRiga("geecB_contenuti",$arrayArticoli[3]);
                    if($articolo4!=null) {
                        $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo4["id"];
                        array_push($arrayArticoliSlide,$articolo4);
                    }

                    $articolo5         = $this->getDb()->leggiSingolaRiga("geecB_contenuti",$arrayArticoli[4]);
                    if($articolo5!=null) {
                        $this->articoliGiaPubblicati[count($this->articoliGiaPubblicati)] = $articolo5["id"];
                        array_push($arrayArticoliSlide,$articolo5);
                    }

                    $this->stampaSlide5Elementi($arrayArticoliSlide);
                }
            }
        }
        
        function stampaSlide5Elementi($arrayArticoliSlide) {
            
            if(count($arrayArticoliSlide)<5) {
                 parent::messaggioDiErrore("Non ci sono sufficienti articoli per mostrare questa slide!");
            }
            else {
                
                $articolo1         = $arrayArticoliSlide[0];
                $articolo2         = $arrayArticoliSlide[1];
                $articolo3         = $arrayArticoliSlide[2];
                $articolo4         = $arrayArticoliSlide[3];
                $articolo5         = $arrayArticoliSlide[4];

                $linkArticolo1     = GeneratoreUrl::creaUrlContenuto($articolo1, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo1["categoria"]!=0) {
                    $categoria1        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo1["categoria"]);
                    $linkCategoria1    = GeneratoreUrl::creaUrlCategoria($categoria1, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria1["nome"] = "";
                    $linkCategoria1     = "";
                }
                $commentiArticolo1 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo1["id"]));
                $dataArticolo1     = date("d/m/Y",strtotime($articolo1["dataPubblicazione"]));

                $linkArticolo2     = GeneratoreUrl::creaUrlContenuto($articolo2, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo2["categoria"]!=0) {
                    $categoria2        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo2["categoria"]);
                    $linkCategoria2    = GeneratoreUrl::creaUrlCategoria($categoria2, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria2["nome"] = "";
                    $linkCategoria2     = "";
                }
                $commentiArticolo2 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo2["id"]));
                $dataArticolo2     = date("d/m/Y",strtotime($articolo2["dataPubblicazione"]));

                $linkArticolo3     = GeneratoreUrl::creaUrlContenuto($articolo3, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo3["categoria"]!=0) {
                    $categoria3        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo3["categoria"]);
                    $linkCategoria3    = GeneratoreUrl::creaUrlCategoria($categoria3, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria3["nome"] = "";
                    $linkCategoria3     = "";
                }
                $commentiArticolo3 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo3["id"]));
                $dataArticolo3     = date("d/m/Y",strtotime($articolo2["dataPubblicazione"]));

                $linkArticolo4     = GeneratoreUrl::creaUrlContenuto($articolo4, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo4["categoria"]!=0) {
                    $categoria4        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo4["categoria"]);
                    $linkCategoria4    = GeneratoreUrl::creaUrlCategoria($categoria4, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria4["nome"] = "";
                    $linkCategoria4     = "";
                }
                $commentiArticolo4 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo4["id"]));
                $dataArticolo4     = date("d/m/Y",strtotime($articolo4["dataPubblicazione"]));   

                $linkArticolo5     = GeneratoreUrl::creaUrlContenuto($articolo5, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo5["categoria"]!=0) {
                    $categoria5        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo5["categoria"]);
                    $linkCategoria5    = GeneratoreUrl::creaUrlCategoria($categoria5, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria5["nome"] = "";
                    $linkCategoria5     = "";
                }
                $commentiArticolo5 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo5["id"]));
                $dataArticolo5     = date("d/m/Y",strtotime($articolo5["dataPubblicazione"]));

	?>
               <div class="item row no-gutters">
                        <div class="col-md-12 col-lg-6">
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo1 ?>"></a></div>
                                        <div class="aspect-ratio-21-18">
                                            <div class="background-image" style="background: url('<?= $articolo1["foto"] ?>')"></div>
                                        </div>
                                        <div class="overlay"></div>
                                        <div class="extra-info">
                                            <a href="$linkCategoria1" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria1["nome"] ?></a>
                                        </div>
                                        <div class="sub-data">
                                            <p class="text-muted small pb-2 border-bottom">
                                                <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo1["autore"] ?>"><?= $articolo1["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo1 ?>
                                                <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo1 ?></span>
                                            </p>
                                            <a href="$linkArticolo1"><h2><?= $articolo1["titolo"] ?></h2></a>
                                        </div>
                                </div>
                            </div><!-- / Articolo -->
                        </div>

                        <div class="col-md-6 col-lg-3">
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo2 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('<?= $articolo2["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                        <a href="$linkCategoria2" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria2["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo2["autore"] ?>"><?= $articolo2["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo2 ?>
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo2 ?></span>
                                        </p>
                                        <a href="$linkArticolo2"><h2><?= $articolo2["titolo"] ?></h2></a>
                                    </div>
                                </div>
                            </div><!-- / Articolo -->
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo4 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('{<?= $articolo4["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                        <a href="$linkCategoria4" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria4["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo4["autore"] ?>"><?= $articolo4["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> $dataArticolo4
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo4 ?></span>
                                        </p>
                                        <a href="$linkArticolo4"><h2><?= $articolo4["titolo"] ?></h2></a>
                                    </div>
                                </div>
                            </div><!-- / Articolo -->
                        </div>

                        <div class="col-md-6 col-lg-3">
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo3 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('<?= $articolo3["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                            <a href="$linkCategoria3" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria3["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo3["autore"] ?>"><?= $articolo3["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo3 ?> 
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo3 ?></span>
                                        </p>
                                        <a href="$linkArticolo3"><h2><?= $articolo3["titolo"] ?></h2></a>
                                    </div>
                                </div>
                            </div><!-- / Articolo -->
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo5 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('<?= $articolo5["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                            <a href="$linkCategoria5" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria5["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo5["autore"] ?>"><?= $articolo5["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo5 ?>
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo5 ?></span>
                                        </p>
                                        <a href="$linkArticolo5"><h2><?= $articolo5["titolo"] ?></h2></a>
                                    </div>
                                </div>
                            </div><!-- / Articolo -->
                        </div>
                </div>
	<?php
            }
        }
        
        function stampaSlide3Elementi($arrayArticoliSlide) {
            if(count($arrayArticoliSlide)<3) {
                 parent::messaggioDiErrore("Non ci sono sufficienti articoli per mostrare questa slide!");
            }
            else {
                
                $articolo1         = $arrayArticoliSlide[0];
                $articolo2         = $arrayArticoliSlide[1];
                $articolo3         = $arrayArticoliSlide[2];

                $linkArticolo1     = GeneratoreUrl::creaUrlContenuto($articolo1, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo1["categoria"]!=0) {
                    $categoria1        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo1["categoria"]);
                    $linkCategoria1    = GeneratoreUrl::creaUrlCategoria($categoria1, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria1["nome"] = "";
                    $linkCategoria1     = "";
                }
                $commentiArticolo1 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo1["id"]));
                $dataArticolo1     = date("d/m/Y",strtotime($articolo1["dataPubblicazione"]));

                $linkArticolo2     = GeneratoreUrl::creaUrlContenuto($articolo2, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo2["categoria"]!=0) {
                    $categoria2        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo2["categoria"]);
                    $linkCategoria2    = GeneratoreUrl::creaUrlCategoria($categoria2, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria2["nome"] = "";
                    $linkCategoria2     = "";
                }
                $commentiArticolo2 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo2["id"]));
                $dataArticolo2     = date("d/m/Y",strtotime($articolo2["dataPubblicazione"]));

                $linkArticolo3     = GeneratoreUrl::creaUrlContenuto($articolo3, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                if($articolo3["categoria"]!=0) {
                    $categoria3        = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo3["categoria"]);
                    $linkCategoria3    = GeneratoreUrl::creaUrlCategoria($categoria3, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
                }
                else {
                    $categoria3["nome"] = "";
                    $linkCategoria3     = "";
                }
                $commentiArticolo3 = $this->getDb()->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo3["id"]));
                $dataArticolo3     = date("d/m/Y",strtotime($articolo3["dataPubblicazione"]));
	?>
                <div class="item row no-gutters">
                        <div class="col-md-12 col-lg-6">
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo1 ?>"></a></div>
                                        <div class="aspect-ratio-21-18">
                                            <div class="background-image" style="background: url('<?= $articolo1["foto"] ?>')"></div>
                                        </div>
                                        <div class="overlay"></div>
                                        <div class="extra-info">
                                            <a href="<?= $linkCategoria1 ?>" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria1["nome"] ?></a>
                                        </div>
                                        <div class="sub-data">
                                            <p class="text-muted small pb-2 border-bottom">
                                                <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo1["autore"] ?>"><?= $articolo1["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo1 ?>
                                                <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo1 ?></span>
                                            </p>
                                            <h2><a href="<?= $linkArticolo1 ?>"> <?= $articolo1["titolo"] ?></a></h2>
                                        </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 col-lg-6">
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo2 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('<?= $articolo2["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                        <a href="<?= $linkCategoria2 ?>" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria2["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo2["autore"] ?>"><?= $articolo2["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo2 ?>
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo2 ?></span>
                                        </p>
                                        <h2><a href="<?= $linkArticolo2 ?>"> <?= $articolo2["titolo"] ?></a></h2>
                                    </div>
                                </div>
                            </div><!-- / Articolo -->
                            <!-- Articolo -->
                            <div class="px-0 border-0">
                                <div class="img-container zoom">
                                    <div class="main-link"> <a href="<?= $linkArticolo3 ?>"></a></div>
                                    <div class="aspect-ratio-21-9">
                                        <div class="background-image" style="background: url('<?= $articolo3["foto"] ?>')"></div>
                                    </div>
                                    <div class="overlay"></div>
                                    <div class="extra-info">
                                            <a href="<?= $linkCategoria3 ?>" class="badge badge-primary rounded-0 py-2 px-3"><?= $categoria3["nome"] ?></a>
                                    </div>
                                    <div class="sub-data">
                                        <p class="text-muted small pb-2 border-bottom">
                                            <i class="fas fa-user mr-2"></i><a href="cerca.php?tipoRicerca=autore&chiaveRicerca=<?= $articolo3["autore"] ?>"><?= $articolo3["autore"] ?></a> <i class="fas fa-calendar-alt ml-4 mr-1"></i> <?= $dataArticolo3 ?>
                                            <span class="float-right"><i class="fas fa-comments"> </i> <?= $commentiArticolo3 ?></span>
                                        </p>
                                        <h2><a href="<?= $linkArticolo3 ?>"> <?= $articolo3["titolo"] ?></a></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            <?php
            }

        }
        
        /*
         * metodo che restituisce una stringa da aggiugnere alla query di ricerca degli articoli
         * nella stringa viene inserito anche il codice per evitare gli articoli non pubblicati e
         * quelli pubblicati con una data successiva a quella della data corrente
         */
        function getStringaArticoliDaEvitare() {
            $dataOdierna = date("Y-m-d H:i");
            $stringaProdottiDaEvitare = "AND stato LIKE 'pubblicato' AND dataPubblicazione<='$dataOdierna'";
            foreach($this->articoliGiaPubblicati as $idArticolo) {
		$stringaProdottiDaEvitare .= " AND id != $idArticolo";
            }
            return $stringaProdottiDaEvitare;
        }
        
        function generaJavascriptSlider($slider,$idSlider) {
            $disposizioneElementi = $this->generaIstruzioniDisposizioneElementi($slider);
            return "<script>
                $(document).ready(function() {
                    $('#$idSlider').owlCarousel({
                        loop:true,
                        autoplayHoverPause:true,
                        $disposizioneElementi
                        nav:true,
                        autoplayTimeout:7000
                    });
                });
            </script>";
            
        }
        
        /*
         * questo metodo deriva dalla classe Visualizzatore Sldier,
         * è stato depotenziato perché questo slider non ha la possibilità di scegliere
         * gli elementi
         */
        function generaIstruzioniDisposizioneElementi($slider) {            
            return "responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    1000:{
                        items:1
                    }
                },";
        }
        
        function getJavascriptAssociato() {
            return $this->javascriptAssociato;
        }
    }